// Copyright 2007 Michael Van Canneyt und C&L Verlag
unit frmmain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Buttons, RTTICtrls, Spin;

type

  { TMainForm }

  TMainForm = class(TForm)
    BClose: TButton;
    BSelect: TButton;
    BSetSelection: TButton;
    ESel: TEdit;
    LSEMinValue: TLabel;
    LSEMaxValue: TLabel;
    LSEIncrement: TLabel;
    LSEFrom: TLabel;
    LSETill: TLabel;
    LESel: TLabel;
    LETest: TLabel;
    CBEnabled: TTICheckBox;
    SEFrom: TSpinEdit;
    SETill: TSpinEdit;
    ETest: TSpinEdit;
    SEMaxValue: TTISpinEdit;
    SEMinValue: TTISpinEdit;
    SEIncrement: TTISpinEdit;
    procedure BCloseClick(Sender: TObject);
    procedure BSelectClick(Sender: TObject);
    procedure BSetSelectionClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  MainForm: TMainForm;

implementation

Resourcestring
  SErrSelStartTooBig = 'Selection start larger than text length.';
  SErrSelEndTooBig = 'Selection end larger than text length.';
  SErrTillSmallerThanFrom = 'Selection end before selection start.';

{ TMainForm }

procedure TMainForm.BCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.BSelectClick(Sender: TObject);
begin
  If SEFrom.Value>=Length(ETest.Text) then
    Raise Exception.Create(SErrSelStartTooBig);
  If SETill.Value>=Length(ETest.Text) then
    Raise Exception.Create(SErrSelEndTooBig);
  If SETill.Value<SEFrom.Value then
    Raise Exception.Create(SErrTillSmallerThanFrom);
  ETest.SelStart:=SEFrom.Value;
  ETest.SelLength:=(SEtill.Value-SEFrom.Value);
end;

procedure TMainForm.BSetSelectionClick(Sender: TObject);
begin
  ETest.SelText:=ESel.Text;
end;



initialization
  {$I frmmain.lrs}

end.

