// Copyright 2007 Michael Van Canneyt und C&L Verlag
unit frmmain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Buttons, RTTICtrls, Spin, ExtCtrls;

type

  { TMainForm }

  TMainForm = class(TForm)
    BClose: TButton;
    BSelect: TButton;
    BSetSelection: TButton;
    EAllowedChars: TEdit;
    ESel: TEdit;
    LCBEchoMode: TLabel;
    LSELabelSpacing: TLabel;
    LCBLabelPosition: TLabel;
    LSEMaxLength: TLabel;
    LEPasswordChar: TLabel;
    LSEFrom: TLabel;
    LSEtill: TLabel;
    Label6: TLabel;
    LEAllowedKeys: TLabel;
    ETest: TLabeledEdit;
    LCBCharCase: TLabel;
    CBCharCase: TTIComboBox;
    SEMaxLength: TTISpinEdit;
    CBReadOnly: TTICheckBox;
    CBEnabled: TTICheckBox;
    SEFrom: TSpinEdit;
    SETill: TSpinEdit;
    EPasswordChar: TTIEdit;
    CBlabelPosition: TTIComboBox;
    SElabelSpacing: TTISpinEdit;
    CBEchoMode: TTIComboBox;
    CBAutoSelect: TTICheckBox;
    procedure BCloseClick(Sender: TObject);
    procedure BSelectClick(Sender: TObject);
    procedure BSetSelectionClick(Sender: TObject);
    procedure ETestKeyPress(Sender: TObject; var Key: char);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  MainForm: TMainForm;

implementation

Resourcestring
  SErrSelStartTooBig = 'Selection start larger than text length.';
  SErrSelEndTooBig = 'Selection end larger than text length.';
  SErrTillSmallerThanFrom = 'Selection end before selection start.';

{ TMainForm }

procedure TMainForm.BCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.BSelectClick(Sender: TObject);
begin
  If SEFrom.Value>=Length(ETest.Text) then
    Raise Exception.Create(SErrSelStartTooBig);
  If SETill.Value>=Length(ETest.Text) then
    Raise Exception.Create(SErrSelEndTooBig);
  If SETill.Value<SEFrom.Value then
    Raise Exception.Create(SErrTillSmallerThanFrom);
  ETest.SelStart:=SEFrom.Value;
  ETest.SelLength:=(SEtill.Value-SEFrom.Value);
end;

procedure TMainForm.BSetSelectionClick(Sender: TObject);
begin
  ETest.SelText:=ESel.Text;
end;

procedure TMainForm.ETestKeyPress(Sender: TObject; var Key: char);

Var
  S : String;

begin
  // Only check alphanumerical characters.
  if Upcase(Key) in ['A'..'Z','0'..'9'] then
    begin
    S:=EAllowedChars.Text;
    If (S<>'') and (Pos(Key,S)=0) then
      Key:=#0;
    end;
end;

initialization
  {$I frmmain.lrs}

end.

