// Copyright 2007 Michael Van Canneyt und C&L Verlag
unit frmmain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Buttons, RTTICtrls, Spin, EditBtn, ExtDlgs;

type

  { TMainForm }

  TMainForm = class(TForm)
    BClose: TButton;
    BSelect: TButton;
    BSetSelection: TButton;
    ETest: TDirectoryEdit;
    EAllowedChars: TEdit;
    ESel: TEdit;
    LEDialogTitle: TLabel;
    LERootDir: TLabel;
    LSEMaxlength: TLabel;
    LSEFrom: TLabel;
    LESETill: TLabel;
    LESel: TLabel;
    LEAllowedChars: TLabel;
    LSEbuttonWidth: TLabel;
    LETest: TLabel;
    SEMaxLength: TTISpinEdit;
    CBReadOnly: TTICheckBox;
    CBEnabled: TTICheckBox;
    SEFrom: TSpinEdit;
    SETill: TSpinEdit;
    CBAutoSelect: TTICheckBox;
    CBButtonOnlyWhenFocused: TTICheckBox;
    CBDirectInput: TTICheckBox;
    CBFlat: TTICheckBox;
    SEButtonWidth: TTISpinEdit;
    CBShowHidden: TTICheckBox;
    EDialogTitle: TTIEdit;
    ERootDir: TTIEdit;
    procedure BCloseClick(Sender: TObject);
    procedure BSelectClick(Sender: TObject);
    procedure BSetSelectionClick(Sender: TObject);
    procedure ETestAcceptDirectory(Sender: TObject; var Value: String);
    procedure ETestKeyPress(Sender: TObject; var Key: char);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  MainForm: TMainForm;

implementation

Resourcestring
  SErrSelStartTooBig = 'Selection start larger than text length.';
  SErrSelEndTooBig = 'Selection end larger than text length.';
  SErrTillSmallerThanFrom = 'Selection end before selection start.';
  SPromptCaption = 'Confirm selected directory';
  SPrompt = 'The following directory was selected. You can still change it:';
  
{ TMainForm }

procedure TMainForm.BCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.BSelectClick(Sender: TObject);
begin
  If SEFrom.Value>=Length(ETest.Text) then
    Raise Exception.Create(SErrSelStartTooBig);
  If SETill.Value>=Length(ETest.Text) then
    Raise Exception.Create(SErrSelEndTooBig);
  If SETill.Value<SEFrom.Value then
    Raise Exception.Create(SErrTillSmallerThanFrom);
  ETest.SelStart:=SEFrom.Value;
  ETest.SelLength:=(SEtill.Value-SEFrom.Value);
end;

procedure TMainForm.BSetSelectionClick(Sender: TObject);
begin
  ETest.SelText:=ESel.Text;
end;

procedure TMainForm.ETestAcceptDirectory(Sender: TObject; var Value: String);
Var
  S: String;

begin
  S:=Value;
  If InputQuery(SPromptCaption,SPrompt,S) then
    Value:=S;
end;


procedure TMainForm.ETestKeyPress(Sender: TObject; var Key: char);

Var
  S : String;

begin
  // Only check alphanumerical characters.
  if Upcase(Key) in ['A'..'Z','0'..'9'] then
    begin
    S:=EAllowedChars.Text;
    If (S<>'') and (Pos(Key,S)=0) then
      Key:=#0;
    end;
end;

initialization
  {$I frmmain.lrs}

end.

