// Copyright 2007 Michael Van Canneyt und C&L Verlag
unit frmmain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, Buttons, songs;

type

  { TMainForm }

  TMainForm = class(TForm)
    Badd: TButton;
    BDelete: TButton;
    BSave: TButton;
    CBAuthors: TCheckBox;
    CBGenre: TComboBox;
    CBauthor: TComboBox;
    ETitle: TLabeledEdit;
    EDuration: TLabeledEdit;
    EAlbum: TLabeledEdit;
    Label1: TLabel;
    LCBAuthor: TLabel;
    LLBSongs: TLabel;
    LBSongs: TListBox;
    procedure BDeleteClick(Sender: TObject);
    procedure BSaveClick(Sender: TObject);
    procedure BaddClick(Sender: TObject);
    procedure CBAuthorsChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure LBSongsSelectionChange(Sender: TObject; User: boolean);
    procedure SongChange(Sender: TObject);
  private
    { private declarations }
    FAuthors : TAuthors;
    FSongs : TSongs;
    function AddSong(S: TSong): Integer;
    procedure CheckButtons;
    function CurrentSong: TSong;
    function GetAuthor: Tauthor;
    procedure SaveSong;
    procedure SetAuthor(const AValue: Tauthor);
    procedure ShowAuthors;
    procedure ShowSong;
    procedure ShowSongs;
    function SongCaption(S: TSong): string;
    function SongModified: Boolean;
  public
    { public declarations }
    property SelectedAuthor : Tauthor Read GetAuthor Write SetAuthor;
  end; 

var
  MainForm: TMainForm;

implementation

{ TMainForm }

procedure TMainForm.LBSongsSelectionChange(Sender: TObject; User: boolean);
begin
  ShowSong;
end;

procedure TMainForm.ShowAuthors;

Var
  I : Integer;

begin
  For I:=0 to FAuthors.Count-1 do
    CBAuthor.Items.AddObject(FAuthors[i].Name,Fauthors[i]);
end;

procedure TMainForm.SongChange(Sender: TObject);
begin
  CheckButtons;
end;

procedure TMainForm.BaddClick(Sender: TObject);

Var
  S : TSong;

begin
  S:=FSongs.Add as TSong;
  S.Author:=Nil;
  S.Title:='New song';
  LBSongs.ItemIndex:=AddSong(S);
  ShowSong;
end;

procedure TMainForm.CBAuthorsChange(Sender: TObject);

Var
  I : Integer;

begin
  With LBSongs do
    For I:=0 to Items.Count-1 do
      Items[i]:=SongCaption(Items.Objects[i] as TSong);
end;

procedure TMainForm.BSaveClick(Sender: TObject);
begin
  If Assigned(CurrentSong) then
    SaveSong;
end;

procedure TMainForm.BDeleteClick(Sender: TObject);

Var
  I : Integer;

begin
  With LBSongs do
    begin
    I:=ItemIndex;
    if (I<>-1) then
      begin
      CurrentSong.Free;
      Items.Delete(I);
      If I<Items.Count then
        ItemIndex:=I
      else
        ItemIndex:=Count-1;
      ShowSong;
      end;
    end;
end;

function TMainForm.CurrentSong : TSong;

begin
  If LBSongs.ItemIndex=-1 then
    Result:=Nil
  else
    Result:=FSongs[LBSongs.itemIndex];
end;

function TMainForm.GetAuthor: Tauthor;

Var
  I : Integer;

begin
  I:=CBAuthor.ItemIndex;
  If I=-1 then
    Result:=Nil
  else
    Result:=CBAuthor.Items.Objects[i] as TAuthor;
end;

function TMainForm.SongCaption(S : TSong) : string;

begin
  Result:=S.Title;
  If CBAuthors.Checked And Assigned(S.Author) then
    Result:=S.Author.Name+' - '+Result;
end;

function TMainForm.AddSong(S : TSong) : Integer;

begin
  Result:=LBSongs.Items.AddObject(SongCaption(S),S);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  FAuthors:=TAuthors.Create(TAuthor);
  FAuthors.Populate;
  ShowAuthors;
  FSongs:=TSongs.Create(TSong);
  FSongs.Authors:=FAuthors;
  FSongs.Populate;
  ShowSongs;
end;

procedure TMainForm.ShowSongs;

Var
  I : Integer;

begin
  For i:=0 to FSongs.Count-1 do
    AddSong(FSongs[i]);
  If FSongs.Count>0 then
    begin
    LBSongs.ItemIndex:=0;
    ShowSong;
    end;
end;


procedure TMainForm.FormDestroy(Sender: TObject);
begin
  FreeAndNil(FSongs);
end;

procedure TMainForm.SaveSong;

begin
  If assigned(CurrentSong) then
    begin
    With CurrentSong do
      begin
      Author              := SelectedAuthor;
      Title               := ETitle.Text;
      Album               := EAlbum.Text;
      Genre               := TGenre(CBGenre.ItemIndex+1);
      Duration := StrToTime(EDuration.Text);
      end;
    With LBSongs do
      Items[ItemIndex]:=SongCaption(CurrentSong);
    CheckButtons;
    end;
end;

procedure TMainForm.SetAuthor(const AValue: Tauthor);

begin
  With CBauthor do
    if (AValue=Nil) then
      ItemIndex:=-1
    else
      Itemindex:=Items.IndexOfObject(AValue);
end;

procedure TMainForm.ShowSong;

begin
  If assigned(CurrentSong) then
    With CurrentSong do
      begin
      SelectedAuthor:=Author;
      ETitle.Text:=Title;
      EAlbum.Text:=Album;
      CBGenre.ItemIndex:=Ord(Genre)-1;
      EDuration.Text:=TimeToStr(Duration);
      end
  else
    begin
    SelectedAuthor:=Nil;
    ETitle.Text:='';
    EAlbum.Text:='';
    CBGenre.ItemIndex:=-1;
    EDuration.Text:='';
    end;
  CheckButtons;
end;

Function TMainForm.SongModified : Boolean;

Var
  S : TSong;

begin
  S:=CurrentSong;
  Result:=Not Assigned(S);
  If Not Result then
    Result:=(SelectedAuthor<>S.Author) or
            (ETitle.Text<>S.Title) or
            (EAlbum.Text<>S.Album) or
            (CBGenre.ItemIndex<>Ord(S.Genre)-1) or
            (EDuration.Text<>TimeToStr(S.Duration));
end;

procedure TMainForm.CheckButtons;

begin
  BAdd.enabled:=Not SongModified;
  BDelete.Enabled:=(CurrentSong<>Nil);
  BSave.Enabled:=SongModified;
end;

initialization
  {$I frmmain.lrs}

end.

