// Copyright 2007 Michael Van Canneyt und C&L Verlag
unit frmmain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Buttons, RTTICtrls, ExtCtrls;

type

  { TMainForm }

  TMainForm = class(TForm)
    BFill: TButton;
    BClear: TButton;
    Badd: TButton;
    BDelete: TButton;
    CBoptimized: TCheckBox;
    CBTest: TComboBox;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    LCBCharCase: TLabel;
    LSEItemHeight: TLabel;
    Label2: TLabel;
    LSETopIndex: TLabel;
    LLBtest: TLabel;
    CBReadOnly: TTICheckBox;
    CBArrowKeysTraverseList: TTICheckBox;
    SEItemHeight: TTISpinEdit;
    CBstyle: TTIComboBox;
    CBSorted: TTICheckBox;
    SEItemindex: TTISpinEdit;
    SEDropDownCount: TTISpinEdit;
    SEAutocomplete: TTICheckBox;
    CBautoSelect: TTICheckBox;
    SEMaxLength: TTISpinEdit;
    CBcharCase: TTIComboBox;
    CGAutoCompleteText: TTICheckGroup;
    CBAutoDropDown: TTICheckBox;
    TISpinEdit1: TTISpinEdit;
    procedure BClearClick(Sender: TObject);
    procedure BDeleteClick(Sender: TObject);
    procedure BFillClick(Sender: TObject);
    procedure BaddClick(Sender: TObject);
  private
    procedure FillListBox(B: Boolean);
    { private declarations }
  public
    { public declarations }
  end; 

var
  MainForm: TMainForm;

implementation

Resourcestring
  SListBox  = 'Listbox demo';
  SAddValue = 'Enter the value to be added to the listbox items';
  

{ TMainForm }

procedure TMainForm.BaddClick(Sender: TObject);

Var
  S : String;

begin
  S:='';
  If InputQuery(SListbox,SAddValue,S) then
    CBTest.Items.Add(S);
end;

procedure TMainForm.BFillClick(Sender: TObject);
begin
  FillListBox(CBOptimized.Checked);
end;

procedure TMainForm.BDeleteClick(Sender: TObject);

begin
  With CBTest do
    Items.Delete(ItemIndex);
end;

procedure TMainForm.BClearClick(Sender: TObject);
begin
  CBTest.Clear;
end;

procedure TMainForm.FillListBox(B : Boolean);

Const
  NoLines = 1000;
  
Var
  I : integer;

begin
  With CBTest.Items do
    begin
    If B then
      BeginUpdate;
    Try
      Clear;
      For I:=1 to NoLines do
        Add('Item number '+IntToStr(i));
    Finally
      If B then
        EndUpdate;
    end;
    end;
end;

initialization
  {$I frmmain.lrs}

end.

