unit frmCreateFromTemplate;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Buttons, ExtCtrls, ProjectTemplates, EditBtn, frmTemplateSettings;

type

  { TTemplateOptionsForm }

  TTemplateOptionsForm = class(TForm)
    BButtons: TBevel;
    BOK: TButton;
    BCancel: TButton;
    BConfig: TButton;
    DEProject: TDirectoryEdit;
    EProjectName: TEdit;
    GBDescription: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    LDescription: TLabel;
    LLBTemplates: TLabel;
    LBTemplates: TListBox;
    procedure BConfigClick(Sender: TObject);
    procedure BOKClick(Sender: TObject);
    procedure LBTemplatesSelectionChange(Sender: TObject; User: boolean);
  private
    FSChanged: Boolean;
    { private declarations }
    FTemplates : TProjectTemplates;
    FTEmplate : TProjectTemplate;
    function GetProjectDir: String;
    function GetProjectName: String;
    procedure SetTemplates(const AValue: TProjectTemplates);
    procedure UpdateDescription;
    procedure LoadTemplates;
  public
    { public declarations }
    Property Templates : TProjectTemplates Read FTemplates Write SetTemplates;
    Property Template : TProjectTemplate Read FTemplate;
    Property ProjectName : String Read GetProjectName;
    Property ProjectDir : String Read GetProjectDir;
    Property SettingsChanged: Boolean Read FSChanged Write FSChanged;
  end;

var
  TemplateOptionsForm: TTemplateOptionsForm;

implementation

resourcestring
  SerrChooseProjectName = 'Please enter a name for the new project.';
  SerrChooseProjectDir = 'Please enter a directory for the new project.';
  SerrSelectTemplate = 'Please select a template to use for the new project.';


{ TTemplateOptionsForm }

procedure TTemplateOptionsForm.LBTemplatesSelectionChange(Sender: TObject;
  User: boolean);
begin
  if (LBTemplates.ItemIndex<>-1) then
    FTemplate:=FTemplates[LBTemplates.ItemIndex]
  else
    FTemplate:=Nil;
  UpdateDescription;
end;

procedure TTemplateOptionsForm.UpdateDescription;

begin
  If (FTemplate=Nil) then
    LDescription.Caption:=SErrSelectTemplate
  else
    LDescription.Caption:=FTemplate.Description;
end;

procedure TTemplateOptionsForm.BOKClick(Sender: TObject);
begin
  if (FTemplate=Nil) then
    Raise Exception.Create(SErrSelectTemplate);
  if (ProjectName='') then
    Raise Exception.Create(SErrChooseProjectName);
  if (ProjectDir='') then
    Raise Exception.Create(SErrChooseProjectDir);
end;

procedure TTemplateOptionsForm.BConfigClick(Sender: TObject);
begin
  With TTemplateSettingsForm.Create(Self) do
    try
      Templates:=Self.Templates;
      If ShowModal=MROK then
        begin
        LoadTemplates;
        SettingsChanged:=True;
        end;
    Finally
      Free;
    end;
end;

procedure TTemplateOptionsForm.SetTemplates(const AValue: TProjectTemplates);


begin
  FTemplates:=AValue;
  LoadTemplates;
end;

procedure TTemplateOptionsForm.LoadTemplates;

Var
  I : Integer;

begin
  With LBTemplates.Items do
     begin
     BeginUpdate;
     Try
       Clear;
       For I:=0 to FTemplates.Count-1 do
         Add(FTemplates[i].Name)
     finally
       EndUpdate;
     end;
     end;
end;

function TTemplateOptionsForm.GetProjectDir: String;
begin
  Result:=DEProject.Text;
end;

function TTemplateOptionsForm.GetProjectName: String;
begin
  Result:=EProjectName.Text;
end;

initialization
  {$I frmcreatefromtemplate.lrs}

end.

