using System;
using System.IO;
using System.Collections.Generic;
using ColossalFramework.IO;
using ColossalFramework.Globalization;

namespace CitiesSkylines
{
    public class po2locale
    {
        static string file_orig = "orig.locale";
        static string file_po = "translated.po";
        static string file_export = "export.locale";
        static string m_NativeName = "NEDERLANDS";
        static string m_EnglishName = "(DUTCH)";
        
        static private bool parse_cmd_line(string [] args) {
	    char state='F';
	    bool error = false;
	    for(int i = 0; i < args.Length; i++) {
              switch (state) {
                case 'F':
                  if (args[i].ToUpper() == "-ORIGINAL")
                    state='O';
                  else if (args[i].ToUpper() == "-PO")
                    state='P';
                  else if (args[i].ToUpper() == "-OUTPUT")
                    state='E';
                  else if (args[i].ToUpper() == "-NATIVENAME")
                    state='N';
                  else if (args[i].ToUpper() == "-ENGLISHNAME")
                    state='M';
                  else if (args[i].ToUpper() == "-VERSION")
                    state='V';
                  else
                    error=true;
                  break;
                case 'O':
                  file_orig = args[i];
                  state='F';
                  break;
                case 'P':
                  file_po = args[i];
                  state='F';
                  break;
                case 'E':
                  file_export = args[i];
                  state='F';
                  break;
                case 'N':
                  m_NativeName = args[i];
                  state='F';
                  break;
                case 'M':
                  m_EnglishName = args[i];
                  state='F';
                  break;
                case 'V':
                  if (!UInt32.TryParse(args[i], out Utils.fileformat_version)) {
                    error = true;
                    break;
                  }
                  state='F';
                  break;
                default:
            	  error = true;
            	  break;
              }
            }
            return error;
        }
        
	static public void Main (string [] args) {
	    if (parse_cmd_line(args)) {
	      Console.WriteLine ("Example: po2locale.exe -original original.locale -po nl.po -output nl.locale -version 2");
	      return;
	    }
	    Console.WriteLine ("Try 'po2locale.exe -help' for help!");
	    Console.WriteLine ("Start conversion with original {0}, po file {1} and export to {2}",file_orig,file_po,file_export);
            if (File.Exists(file_orig) && File.Exists(file_po) && Directory.Exists(".")) {
                using (Stream stream = new FileStream(file_orig, FileMode.Open, FileAccess.Read)) {
                    Locale m_Locale = DataSerializer.Deserialize<Locale>(stream, DataSerializer.Mode.File);
                    Dictionary<Locale.Key, string> m_LocalizedStrings = Utils.GetPrivateField<Dictionary<Locale.Key, string>>(m_Locale, "m_LocalizedStrings");
                    Dictionary<Locale.Key, string> l_LocalizedStrings = new Dictionary<Locale.Key, string>(m_LocalizedStrings);
                    List<string> lines = new List<string>();
                    using (StreamReader file = new StreamReader(file_po)) {
                        string line;
                        while ((line = file.ReadLine()) != null) {
                            lines.Add(line);
                        }
                    }
		    string m_Identifier = "";
		    string m_Key = null;
		    string m_Index = "";
		    string msgid = "";
		    string msgstr = "";
		    char state = ' ';
                    for (int i = 0; i < lines.Count; i++) {
                        int j = 0;
			string l = lines[i].Trim();
			bool fail = false;
			if (l.Length>0) {
			  switch (l[0]) {
			    case '#':
			      j = 1;
			      if ((j>=l.Length) ||  (l[j]!='.'))
			        break;
			      if (m_Identifier.Length !=0 && msgid.Length != 0 && msgstr.Length != 0) {
			        msgstr = msgstr.Replace(@"\r", "\r").
			                        Replace(@"\n", "\n").
				                Replace(@"\\", "\\").
				                Replace(@"\""", @"""");
				Console.WriteLine("Ident '{0}'  Key {1}' Index '{2}' 'msgid '{3}' msgstr '{4}'",m_Identifier,m_Key,m_Index,msgid,msgstr);
				Locale.Key key = new Locale.Key();
				key.m_Identifier = m_Identifier;
				key.m_Index = int.Parse(m_Index);
				key.m_Key = m_Key;
				if (l_LocalizedStrings.ContainsKey(key)) {
				  Console.WriteLine("Replace");
				  l_LocalizedStrings.Remove(key);
				  l_LocalizedStrings.Add(key, msgstr);
				} else {
				  Console.WriteLine("Add");
				  l_LocalizedStrings.Add(key, msgstr);
				}
			      }
			      m_Identifier = "";
			      m_Key = null;
			      m_Index = "";
			      msgid = "";
			      msgstr = "";
			      state = ' ';
			      j++;
			      while ((j<l.Length) && Char.IsWhiteSpace(l[j]))
			        j++;
			      if ((j>=l.Length) || (l[j]!='"')) {
			        fail = true;
			        break;
			      }
			      j++;
			      while ((j<l.Length) && (l[j]=='_' || Char.IsLetterOrDigit(l[j]))) {
			        m_Identifier += l[j];
			        j++;
			      }
			      if ((j<l.Length) && (l[j]=='[')) {
				j++;
			        while ((j<l.Length) && (l[j]!=']')) {
			          m_Key += l[j];
			          j++;
			        }
			        j++;
			      }
			      if ((j>=l.Length) || (l[j]!=':')) {
			        fail = true;
			        break;
			      }
			      j++;
			      while ((j<l.Length) && (Char.IsDigit(l[j]))) {
			        m_Index += l[j];
			        j++;
			      }
			      break;
			    case 'm':
			      if (l.Substring(0,5) == "msgid") {
			        j = 5;
			        state = 'I';
			        while ((j<l.Length) && Char.IsWhiteSpace(l[j]))
			          j++;
			        if ((j>=l.Length) || (l[j]!='"')) {
			          fail = true;
			          break;
			        }
			        j++;
			        while ((j<l.Length) && ((l[j]!='"') || (l[j-1]=='\\'))) {
			          msgid += l[j];
			          j++;
			        }
			        if ((j>=l.Length) || (l[j]!='"')) {
			          fail = true;
			          break;
			        }
			      } else if (l.Substring(0,6) == "msgstr") {
			        j = 6;
			        state = 'S';
			        while ((j<l.Length) && Char.IsWhiteSpace(l[j]))
			          j++;
			        if ((j>=l.Length) || (l[j]!='"')) {
			          fail = true;
			          break;
			        }
			        j++;
			        while ((j<l.Length) && ((l[j]!='"') || (l[j-1]=='\\'))) {
			          msgstr += l[j];
			          j++;
			        }
			        if ((j>=l.Length) || (l[j]!='"')) {
			          fail = true;
			          break;
			        }
			      }
			      break;
			    case '"':
			      switch (state) {
			        case 'I':
				  if ((j>=l.Length) || (l[j]!='"')) {
				    fail = true;
				    break;
				  }
				  j++;
				  while ((j<l.Length) && ((l[j]!='"') || (l[j-1]=='\\'))) {
				    msgid += l[j];
				    j++;
				  }
				  if ((j>=l.Length) || (l[j]!='"')) {
				    fail = true;
				    break;
				  }
			          break;
			        case 'S':
				  if ((j>=l.Length) || (l[j]!='"')) {
				    fail = true;
				    break;
				  }
				  j++;
				  while ((j<l.Length) && ((l[j]!='"') || (l[j-1]=='\\'))) {
				    msgstr += l[j];
				    j++;
				  }
				  if ((j>=l.Length) || (l[j]!='"')) {
				    fail = true;
				    break;
				  }
			          break;
			        default:
				  fail = true;
				  break;
			      }
			      break;
			    default:
			      fail = true;
			      break;
			  }
			}
			if (fail)
			  Console.WriteLine("Failure while parsing po file at line {0} pos {1}!",i,j);
/*			else
                          Console.WriteLine("{3}: Ident '{0}'  Key {1}' Index '{2}' msgid '{4}' msgstr '{5}'",m_Identifier,m_Key,m_Index,i,msgid,msgstr);*/
                    }
		    if (m_Identifier.Length !=0 && msgid.Length != 0 && msgstr.Length != 0) {
		        msgstr = msgstr.Replace(@"\r", "\r").
		                        Replace(@"\n", "\n").
			                Replace(@"\\", "\\").
			                Replace(@"\""", @"""");
			Console.WriteLine("Ident '{0}'  Key {1}' Index '{2}'",m_Identifier,m_Key,m_Index);
			Locale.Key key = new Locale.Key();
			key.m_Identifier = m_Identifier;
			key.m_Index = int.Parse(m_Index);
			key.m_Key = m_Key;
			if (l_LocalizedStrings.ContainsKey(key)) {
			  Console.WriteLine("Replace");
			  l_LocalizedStrings.Remove(key);
			  l_LocalizedStrings.Add(key, msgstr);
			} else {
			  Console.WriteLine("Add");
			  l_LocalizedStrings.Add(key, msgstr);
			}
		    }
                    if (m_EnglishName.Length != 0)
                      Utils.SetPrivateField<string>(m_Locale, "m_EnglishName", m_EnglishName);
                    if (po2locale.m_NativeName.Length != 0)
                      Utils.SetPrivateField<string>(m_Locale, "m_NativeName", po2locale.m_NativeName);
                    Utils.SetPrivateField<Dictionary<Locale.Key, string>>(m_Locale, "m_LocalizedStrings", l_LocalizedStrings);
                    Utils.ExportFile(file_export, m_Locale);
                    Console.WriteLine("export success !");
                }
            } else
		Console.WriteLine("file or directory not exist !");
	}
    }
}