using System;
using System.IO;
using System.Collections.Generic;
using ColossalFramework.IO;
using ColossalFramework.Globalization;

namespace CitiesSkylines
{
    public class local2po
    {
        static string file_input = "en.locale";
        static string file_output = "en.po";
        
        static private bool parse_cmd_line(string [] args) {
	    char state='F';
	    bool error = false;
	    for(int i = 0; i < args.Length; i++) {
              switch (state) {
                case 'F':
                  if (args[i].ToUpper() == "-INPUT")
                    state='I';
                  else if (args[i].ToUpper() == "-OUTPUT")
                    state='E';
                  else
                    error=true;
                  break;
                case 'I':
                  file_input = args[i];
                  state='F';
                  break;
                case 'E':
                  file_output = args[i];
                  state='F';
                  break;
                default:
            	  error = true;
            	  break;
              }
            }
            return error;
        }

        static public void Main (string [] args)
	{
	    if (parse_cmd_line(args)) {
	      Console.WriteLine ("Example: locale2po.exe -input en.locale -output en.po");
	      return;
	    }
	    Console.WriteLine ("Convert {0} into {1}",file_input,file_output);
	    if (File.Exists(file_input) && Directory.Exists("."))
	    {
		using (Stream stream = new FileStream(file_input, FileMode.Open, FileAccess.Read))
		{
		    Locale m_Locale = DataSerializer.Deserialize<Locale>(stream, DataSerializer.Mode.File);
		    Dictionary<Locale.Key, string> m_LocalizedStrings = Utils.GetPrivateField<Dictionary<Locale.Key, string>>(m_Locale, "m_LocalizedStrings");
		    Utils.ExportPOFile(file_output, m_LocalizedStrings);
		    Console.WriteLine("export success !");
		}
	    }
	    else
	    {
		Console.WriteLine("file or directory not exist !");
	    }
	}
    }
}