UNIT GRPRINT;
Interface
USES CRT,DOS,GRAPH;
TYPE
PrinterTypen =(HP,EPSON);
CONST
PrinterType:PrinterTypen=HP;
VAR
PRN:Text;

Procedure DrukVenster(Dichtheid:Word);
Implementation
CONST
  Esc = #27;
VAR
  Breedte, Hoogte : Word;
  ViewPort : ViewPortType;
  Intro    :String[10];
{$F+}
FUNCTION NulFunctie(Rec:TextRec):Integer;
{$F-}
BEGIN
  NulFunctie:=0;
END;
{$F+}
FUNCTION UitvoerNaarPrinter(VAR Rec:TextRec):Integer;
{$F-}
VAR
  Reg:Registers;
  Wijzer:Word;
BEGIN
  WITH REC DO
  BEGIN
     Wijzer:=0;
     Reg.AH:=16;
     WHILE (Wijzer<BufPos)AND(Reg.AH AND 16 = 16) DO
     BEGIN
        Reg.AH:=0;
        Reg.AL:=Ord(BufPtr^[Wijzer]);
        Reg.DX:=UserData[1];
        Intr($17,Reg);
        INC(Wijzer)
     END;
     BufPos:=0;
     IF Reg.AH AND 16 = 16 THEN 
     UitvoerNaarPrinter:=0
     ELSE
     IF Reg.AH AND 32 = 31 THEN
     UitvoerNaarPrinter:=159
     ELSE
     UitvoerNaarPrinter:=160
   END
END;

PROCEDURE InitHP(Dichtheid:Integer);
CONST
  CursorPositie:String='5';
VAR
  PuntenPerInch:string[3];
BEGIN
  CASE Dichtheid OF
  1:PuntenPerInch:= '75';
  2:PuntenPerInch:='100';
  3:PuntenPerInch:='150';
  4:PuntenPerInch:='300';
  ELSE PuntenPerInch:='100'
  END;
  Write(PRN, Esc + 'E');
  Write(PRN, Esc+'*t'+PuntenPerInch +'R');
  Write(PRN, Esc+'&a'+CursorPositie+'C');
  Write(PRN, Esc + '*r1A');
END;

PROCEDURE InitEpson(Dichtheid:Integer);
VAR
  Regelafstand:String[10];
BEGIN
  RegelAfstand := #27 + '3' + #24;
  CASE Dichtheid OF
     1 :   Intro := #27 + 'K';
     2 :   Intro := #27 + 'L';
     3 :   Intro := #27 + 'Y';
     4 :   Intro := #27 + 'Z';
    ELSE Intro:=#27+'L'
  End;
  Write (PRN, RegelAfstand);
END;

PROCEDURE SluitHP;
BEGIN
   Write(PRN, Esc + '*rB');
   Write(PRN, Esc + 'E')
END;

PROCEDURE SluitEpson;
BEGIN
   Write(PRN,#12);
   Write (PRN, #27 + '@');
END;

Procedure HPAfdruk(Dichtheid:Word);
VAR
  RegelLengte :String[2];
  I           :Integer;

  Procedure PuntenLijn (Y : Word);
  VAR
     Regel : String[255];
     Basis   : Word;
     BitNr, ByteNr, DataByte : Byte;
     Kleur :Word;

  BEGIN
     Regel := Intro;
     FOR ByteNr := 0 TO Breedte DO
     BEGIN
        DataByte := 0;
        Basis := 8 * ByteNr;
        FOR BitNr := 0 TO 7 DO
        BEGIN
           Kleur:= GetPixel(BitNr + Basis, Y);
           IF (Kleur <> 0)AND(Kleur > 9) THEN
           DataByte := DataByte + 128 SHR BitNr;
        END;
        Regel := Regel + Chr(DataByte)
     END;
     Write(PRN, Regel)
  END;

BEGIN
  GetViewSettings (ViewPort);
  WITH ViewPort DO
  BEGIN
     Breedte:= (X2 + 1) - X1;
     Breedte:= (Breedte - 7) DIV 8;
     Hoogte := Y2 - Y1
  END;
  Str(Breedte+1, RegelLengte);
  Intro := Esc + '*b' + RegelLengte + 'W';
  InitHp(Dichtheid);
  FOR I := 0 TO Hoogte + 1 DO PuntenLijn(I);
  SluitHP
END;

PROCEDURE EPAfdruk(Dichtheid:Word);
VAR
  X, Y,YOfs            : integer;
  BitGegevens, Bits    : Byte;
  Kleur                :Byte;

BEGIN
  GetViewSettings (ViewPort);
  WITH ViewPort DO
  BEGIN
     Hoogte := Y2 - Y1;
     Breedte := X2 + 1 - X1
  END;
  InitEpson(Dichtheid);
  Y :=0;
  WHILE Y < Hoogte DO
  BEGIN
    Write 
    (PRN, Intro, Chr(Lo(Breedte)),Chr(Hi(Breedte)));
    FOR X := 0 TO Breedte-1 DO
    BEGIN
      BitGegevens := 0;
      IF Y + 7 <= Hoogte THEN Bits := 7
      ELSE  Bits := Hoogte - Y;
      FOR YOfs := 0 TO Bits DO
      BEGIN
        Kleur:=GetPixel(X,YOfs+Y);
        IF ((Kleur <> 0)AND(Kleur>9)) THEN
        BitGegevens := BitGegevens + 128 SHR YOfs
      END;
      Write (PRN, Chr(BitGegevens))
    END;
    WriteLn (PRN);
    Inc (Y,8)
  END;
  SluitEpson
END;

PROCEDURE DrukVenster(Dichtheid:Word);
BEGIN
  CASE PrinterType OF
  HP    : HPAfdruk(Dichtheid);
  EPSON : EPAfdruk(Dichtheid)
  END
END;

BEGIN
  WITH TextRec(PRN) DO
  BEGIN
     Mode        := FmOutput;
     BufSize     := SizeOf (Buffer);
     BufPtr      := @Buffer;
     BufPos      := 0;
     OpenFunc    := @NulFunctie;
     InOutFunc   := @UitvoerNaarPrinter;
     FlushFunc   := @UitvoerNaarPrinter;
     CloseFunc   := @UitvoerNaarPrinter;
     UserData[1] := 0
  END
END.
