PROGRAM GRAPH_4;
USES CRT, GRAPH;
VAR
  Driver, Instelling:Integer;

FUNCTION TekenFiguren:Char;
VAR
  Breed,Hoog,Diep,AspectX,AspectY:Word;
  X,Y:Integer;
  I:Byte;

  PROCEDURE VulVlakken(B,H:Word;T:Boolean);
  VAR
  X,Y:Integer;
  BEGIN
     X:=GetX;
     Y:=GetY;
     SetFillStyle(SolidFill,Red);
     FloodFill(X+1,Y+1,GetColor);
     SetFillStyle(SolidFill,Green);
     FloodFill(X+B+1,Y+H DIV 2,GetColor);
     IF T THEN
     BEGIN
        SetFillStyle(SolidFill,Yellow);
        FloodFill(X+B DIV 2,Y-1,GetColor)
     END
  END;

BEGIN
  X:=GetMaxX DIV 20;
  Y:=GetMaxX DIV 10;
  Breed:=GetMaxX DIV 5;
  Hoog:=Breed;
  Diep:=Breed DIV 4;
  Bar3D(X,Y,X+Breed,Y+Hoog,Diep,TopOn);
  MoveTo(X,Y);
  VulVlakken(Breed,Hoog,True);
  X:=X+Breed+Diep+(GetMaxX DIV 10);
  MoveTo(0,0);
  FOR I:= 0 TO 1 DO
  BEGIN
     MoveTo(X,Y);
     LineRel(0,Hoog);
     LineRel(Breed,0);
     LineRel(0,-Hoog);
     LineRel(-Breed,0);
     LineRel(Breed DIV 4,-Diep*3 DIV 5);
     LineRel(Breed,0);
     LineRel(0,Hoog);
     LineRel(-Breed DIV 4,Diep * 3 DIV 5);
     MoveRel(0,-Hoog);
     LineRel(Breed DIV 4,-Diep*3 DIV 5);
     MoveTo(X,Y);
     VulVlakken(Breed,Hoog,True);
     GetAspectRatio(AspectX,AspectY);
     Hoog := Round(AspectX / AspectY * Breed);
     X:=X+Breed+Diep+(GetMaxX DIV 10)
   END;
   SetTextStyle(SmallFont,HorizDir,6);
   Y:=GetMaxY-(5*TextHeight('M'));
   SetWriteMode(XORPut);
   SetTextJustify(LeftText,CenterText);
   OutTextXY(GetMaxX DIV 2,Y,
            'Wilt U het scherm opslaan? (J/N)');
   TekenFiguren:=ReadKey;
   OutTextXY(GetMaxX DIV 2,Y,
            'Wilt U het scherm opslaan? (J/N)');
END;

PROCEDURE SlaSchermOp;
CONST
  Van:Longint=0;
VAR
  Delen:Array[1..4] OF Word;
  AantalBytes:Word;
  I:Byte;
  F:File;
  P:Pointer;
BEGIN
   Assign(F,'PLAATJE.GRF');
   Rewrite(F,1);
   FOR I:= 1 TO 3 DO Delen[I]:=(GetMaxY DIV 4)*I;
   Delen[4]:=GetMaxY;
   FOR I := 1 TO 4 DO
   BEGIN
      AantalBytes:=ImageSize(0,Van,GetMaxX,Delen[I]);
      GetMem(P,AantalBytes);
      GetImage(0,Van,GetMaxX,Delen[I],P^);
      BlockWrite(F,P^,AantalBytes);
      FreeMem(P,AantalBytes);
      Van:=Delen[I]
   END;
   RestoreCrtMode;
   ClrScr;
   GotoXy(20,10);
   Write
   ('Het grafische scherm is opgeslagen op schijf');
   GotoXY(20,11);
   Write('      We zijn nu weer in een tekstscherm');
   GotoXy(20,12);
   Write
   ('  Druk op toets om scherm weer in te lezen');
   ReadKey;
   DetectGraph(Driver,Instelling);
   SetGraphMode(1);
   Reset(F,1);
   Van:=0;
   FOR I := 1 TO 4 DO
   BEGIN
      AantalBytes:=ImageSize(0,Van,GetMaxX,Delen[I]);
      GetMem(P,AantalBytes);
      BlockRead(F,P^,AantalBytes);
      PutImage(0,Van,P^,NormalPut);
      FreeMem(P,AantalBytes);
      Van:=Delen[I];
   END;
   OutTextXY(GetMaxX DIV 2, 
   GetMaxY-(5*TextHeight('M')),
   'Druk op willekeurige toets..');
   ReadKey
END;

BEGIN
  Driver:=Detect;
  InitGraph(Driver,Instelling,'');
  SetGraphMode(1);
  SetBKColor(LightGray);
  IF TekenFiguren IN ['J','j'] THEN SlaSchermOp;
  CloseGraph
END.
