PROGRAM GRAPH_2;
USES CRT, GRAPH, DIVERSEN;
CONST
   ScriptFont =5;
   SimplexFont=6;

FUNCTION BinWord(BitPatroon:String):Word;
VAR
  I:Byte;
  B,J:Word;
BEGIN
   B:=0;
   J:=1;
   IF Length(BitPatroon)>=16 THEN
   BitPatroon:=Copy(BitPatroon,1,16)
   ELSE
   FOR I:=Length(BitPatroon) TO 16 DO      
   BitPatroon:='0'+BitPatroon;
   For I:= Length(BitPatroon) DownTo 1 DO
   BEGIN
      IF NOT (BitPatroon[I] IN ['0','1']) THEN
      BEGIN
        BinWord:=0;
        Exit
      END
      ELSE
      BEGIN
        B:=B +(ORD(BitPatroon[I])-48) * J;
        J:= J * 2 ;
      END
   END;
   BinWord:=B
END;

PROCEDURE Lijnen;
CONST
Deler:Byte=6;

VAR
  Viewrec:ViewPortType;
  
BEGIN
  SetFillStyle(SolidFill,Blue);
  Bar(0,0,GetMaxX,GetMaxY);
  SetColor(White);
  GetViewSettings(ViewRec);
  WITH ViewRec DO
  BEGIN
     Line((X2-X1)DIV Deler,0,(X2-X1) DIV Deler,Y2);
     SetLineStyle(Dottedln,0,NormWidth);
     Line((X2-X1)DIV Deler*2,0,
          (X2-X1) DIV Deler*2,Y2);
     SetLineStyle(Centerln,0,NormWidth);
     Line((X2-X1)DIV Deler*3,0,
          (X2-X1) DIV Deler*3,Y2);
     SetLineStyle(DashedLn,0,ThickWidth);
     Line((X2-X1)DIV Deler*4,0,
          (X2-X1) DIV Deler*4,Y2);
      SetLineStyle(UserBitLn,BinWord('000001110000'),
                   ThickWidth);
     Line((X2-X1)DIV Deler*5,0,
          (X2-X1) DIV Deler*5,Y2);
     SetLineStyle(SolidLn,0,NormWidth)
  END
END;

Procedure Rechthoeken;
VAR
  ViewRec:ViewPortType;
  Hor,Vert:Word;
  Patroon:FillPatternType;
BEGIN
   SetFillStyle(SolidFill,Yellow);
   Bar(0,0,GetMaxX,GetMaxY);
   GetViewSettings(ViewRec);
   SetColor(Blue);
   SetLineStyle(SolidLn,0,NormWidth);
   WITH ViewRec DO
   BEGIN
      Hor :=X2-X1;
      Vert:=Y2-Y1;
      Patroon[1]:=BinWord('00000000');
      Patroon[2]:=Binword('00000000');
      Patroon[3]:=Binword('00111100');
      Patroon[4]:=BinWord('00100100');
      Patroon[5]:=BinWord('00100100');
      Patroon[6]:=BinWord('00111100');
      Patroon[7]:=BinWord('00000000');
      Patroon[8]:=BinWord('00000000');
      SetFillPattern(Patroon,LightGreen);
      RecTangle(Hor * 10 DIV 100,Vert * 10 DIV 100,
                Hor-(Hor * 10 DIV 100),
                Vert-(Vert * 10 DIV 100));
      FloodFill(Hor DIV 2,Vert DIV 2,GetColor)
   END
END;

PROCEDURE Bars;
VAR
  ViewRec:ViewPortType;
  Hor,Vert:Word;
BEGIN
   SetFillStyle(SolidFill,LightRed);
   Bar(0,0,GetMaxX,GetMaxY);
   GetViewSettings(ViewRec);
   WITH ViewRec DO
   BEGIN
      Hor :=X2-X1;
      Vert:=Y2-Y1;
      SetFillStyle(LtSlashFill,lightBlue);
      Bar(10 * Hor DIV 100,20 * Vert DIV 100,
          Hor -(Hor * 10 div 100),40 * Vert DIV 100);
      SetFillStyle(SlashFill,White);
      Bar(25 * Hor DIV 100,60 * Vert DIV 100,
          Hor -(Hor * 25 div 100),90 * Vert DIV 100)
   END
END;

PROCEDURE Bar_3D;
Const
  Aantal = 5;

VAR
  ViewRec:ViewPortType;
  Hor,Vert,Breed,Start,Bodem,Diep:Word;
  I:Byte;
BEGIN
   SetFillStyle(Solidfill,Blue);
   Bar(0,0,GetMaxX,GetMaxY);
   GetViewSettings(ViewRec);
   Randomize;
   WITH ViewRec DO
   BEGIN
      Hor :=X2-X1;
      Vert:=Y2-Y1;
      Breed:=Hor DIV (Aantal+1);
      Bodem:=Vert-(Vert * 15 DIV 100);
      Diep:=Breed * 20 DIV 100;
      Start:=10 * Hor DIV 100;
      FOR I:= 1 TO Aantal DO
      BEGIN
         REPEAT 
            SetColor(Random(GetMaxColor)) 
         UNTIL GetColor<> Blue;
         SetFillStyle(Random(11),Random(GetMaxColor));
         Bar3D(Start,Random(Vert),Start+Breed,Bodem,
              Diep,TopOn);
         INC(Start,Breed)
      END
   END
END;

PROCEDURE Cirkel;
CONST
Afstand:Byte=6;
VAR
  ViewRec:ViewPortType;
  Hor,Vert,Radius,Kleur:Word;
BEGIN
   SetFillStyle(Solidfill,White);
   Bar(0,0,GetMaxX,GetMaxY);
   GetViewSettings(ViewRec);
   WITH ViewRec DO
   BEGIN
      Hor :=X2-X1;
      Vert:=Y2-Y1
   END;
   Randomize;
   FOR Radius:=1 TO Hor DIV 2 DO
   BEGIN
      IF Radius MOD Afstand = 0 THEN
      BEGIN
         REPEAT Kleur:=Random(GetMaxColor)
         UNTIL Kleur<> White;
         SetColor(Kleur);
         Circle(Hor DIV 2,Vert DIV 2,Radius)
      END;
   END
END;

PROCEDURE Bochten;
VAR
  ViewRec:ViewPortType;
  Hor,Vert:Word;
BEGIN
   SetFillStyle(SolidFill,Cyan);
   SetLinestyle(SolidLn,0,NormWidth);
   Bar(0,0,GetMaxX,GetMaxY);
   GetViewSettings(ViewRec);
   WITH ViewRec DO
   BEGIN
      Hor :=X2-X1;
      Vert:=Y2-Y1
   END;
   SetColor(Black);
   SetFillStyle(SolidFill,Red);
   Arc(Hor * 30 DIV 100,Vert * 20 DIV 100,45,
       270,Hor * 15 DIV 100);
   Arc(Hor * 70 DIV 100,Vert * 20 DIV 100, 270,
       135,Hor * 15 DIV 100);
   Ellipse(Hor DIV 2, Vert DIV 2, 270,90,Hor DIV 4,
           Vert DIV 8);
   Ellipse(Hor DIV 2, Vert DIV 2, 0,360,Hor DIV 2,
           Vert DIV 2);
   FillEllipse(Hor DIV 2, Vert DIV 4*3,Hor DIV 3,
           Vert DIV 9)
END;

PROCEDURE Taart;
CONST
Percentages:Array[1..4] OF Word=(10,22,37,31);
Start:Word=0;
Totaal:Word=0;
  PROCEDURE HaalTekstCoordinaten(MiddenlijnInGraden,
                  Radius : word; var X, Y : integer);
  VAR
     Radialen : Real;
  BEGIN
     Radialen := MiddenlijnInGraden * Pi / 180;
     X := Round(Cos(Radialen) * Radius);
     Y := Round(Sin(Radialen) * Radius)
  END;

VAR
  ViewRec:ViewPortType;
  Hor,Vert:Word;
  I,Einde,Kleur,LaatsteKleur:Word;
  PercStr:String;
  X,Y:Integer;
BEGIN
   SetFillStyle(SolidFill,LightGreen);
   SetLinestyle(SolidLn,0,NormWidth);
   Bar(0,0,GetMaxX,GetMaxY);
   GetViewSettings(ViewRec);
   WITH ViewRec DO
   BEGIN
      Hor :=X2-X1;
      Vert:=Y2-Y1
   END;
   SetColor(Black);
   Kleur:=Red;
   Randomize;
   FOR I:=1 TO 4 DO
   BEGIN
     SetFillStyle(SolidFill,Kleur);
     LaatsteKleur:=Kleur;
     REPEAT
     Kleur:=Random(GetMaxColor)
     UNTIL NOT(Kleur IN
     [LaatsteKleur,Red,LightGreen]);
     INC(Totaal,Percentages[I]);
     Einde:= Totaal * 360 DIV 100;
     PieSlice(Hor DIV 2,Vert DIV 2,Start,
              Einde,Hor DIV 2);
     Str(Percentages[I],PercStr);
     SetTextJustify(CenterText,CenterText);
     IF Kleur IN [Yellow,White,Lightblue] THEN
     SetColor(Black) ELSE SetColor(White);
     SetTextStyle( SmallFont,HorizDir,4);
     HaalTekstCoordinaten((Start + Einde)DIV 2,
                           Hor DIV 4,X,Y);
     OutTextXY(Hor DIV 2 + X,
               Vert DIV 2 - Y,PercStr+'%');
     Start:=Einde
   END
END;

PROCEDURE Tekenen;
VAR
  ViewRec:ViewPortType;
  Hor,Vert:Word;
  Huis:Array[0..6] Of PointType;
BEGIN
   SetFillStyle(Solidfill,Brown);
   Bar(0,0,GetMaxX,GetMaxY);
   GetViewSettings(ViewRec);
   WITH Viewrec DO
   BEGIN
      Hor :=X2-X1;
      Vert:=Y2-Y1
   END;
   SetColor(Black);
   MoveTo(Hor * 20 DIV 100,Vert * 20 DIV 100);
   LineTo(Hor DIV 2,0);
   LineTo(Hor * 80 DIV 100,Vert * 20 DIV 100);
   LineTo(Hor * 20 DIV 100,Vert * 20 DIV 100);
   SetFillStyle(XHatchFill,Red);
   FloodFill(Hor DIV 2,Vert * 10 DIV 100,GetColor);
   LineTo(Hor * 20 DIV 100,Vert * 40 DIV 100);
   LineTo(Hor * 80 DIV 100,Vert * 40 DIV 100);
   LineTo(Hor * 80 DIV 100,Vert * 20 DIV 100);
   SetFillStyle(LineFill,Red);
   FloodFill(Hor Div 2, Vert * 30 Div 100,GetColor);
   SetFillStyle(XHatchFill,Red);
   Huis[0].X:=Hor * 20 DIV 100; 
   Huis[0].Y:=Vert * 70 DIV 100;
   Huis[1].X:=Hor DIV 2;
   Huis[1].Y:=Vert* 50 DIV 100;
   Huis[2].X:=Hor * 80 DIV 100; 
   Huis[2].Y:=Vert * 70 DIV 100;
   Huis[3].X:=Hor * 20 DIV 100; 
   Huis[3].Y:=Vert * 70 DIV 100;
   FillPoly(4,Huis);
   SetFillStyle(LineFill,Red);
   Bar(Hor * 20 DIV 100,Vert*70 DIV 100,
       Hor * 80 DIV 100, Vert * 90 DIV 100)
END;

PROCEDURE ZetRijen(Hor,Vert:Word);
CONST
  Teller    :Word=0;
  Percentage:Byte=15;

VAR
  I,J:Word;
  X,Y,X1,Y1,X2,Y2,Ruimte:Word;
  Ch:Char;
BEGIN
  X:=GetMaxX;
  Y:=GetMaxY-(GetMaxY * Percentage DIV 100);
  FOR I:= 0 TO VERT-1 DO
  BEGIN
     Y1:=(Y DIV Vert *I);
     Y2:=(Y DIV Vert *(I+1));
     Y1:=Y1+((Y2-Y1)* Percentage DIV 100);
     Y2:=Y2-((Y2-Y1)* Percentage DIV 100);
     FOR J:= 0 TO Hor-1 DO
     BEGIN
        X1:=(X DIV Hor * J);
        X2:=(X DIV Hor * (J+1));
        X1:=X1+((X2-X1) * Percentage DIV 100);
        X2:=X2-((X2-x1) * Percentage DIV 100);
        SetViewPort(X1,Y1,X2,Y2,ClipOn);
        CASE Teller OF
           0:Lijnen;
           1:Rechthoeken;
           2:Bars;
           3:Bar_3D;
           4:Cirkel;
           5:Bochten;
           6:Taart;
           7:Tekenen
        END;
        SetViewPort(0,0,GetMaxX,GetMaxY,True);
        Ruimte:=Y DIV Vert * Percentage DIV 100;
        CASE Teller OF
           0: BEGIN
                 SetTextStyle(DefaultFont,HorizDir,1);
                 OutTextXY(X1+(X2-X1) DIV 2,
                        Y2+Ruimte,'Lijnen')
                 END;                
           1: BEGIN
                 SetColor(LightBlue);
                 SetTextStyle(TriplexFont,HorizDir,1);
                 OutTextXY(X1+(X2-X1) DIV 2,
                      Y2+Ruimte,'Rechthoeken vullen')
              END;
            2:BEGIN
                 SetColor(Yellow);
                 SetTextStyle(SmallFont ,HorizDir,4);
                 OutTextXY(X1+(X2-X1) DIV 2,
                 Y2+Ruimte,'Bars met patroon')
              END;
            3:BEGIN
                 SetColor(Green);
                 SetTextStyle
                 (SansSerifFont,HorizDir,1);
                 OutTextXY(X1+(X2-X1) DIV 2,Y2+Ruimte,
                           '3-D Bars')
              END;
            4:BEGIN
                 SetColor(Magenta);
                 SetTextStyle( GothicFont,HorizDir,1);
                 OutTextXY(X1+(X2-X1) DIV 2,
                               Y2+Ruimte,'Cirkels')
              END;
            5:BEGIN
                 SetColor(LightCyan);
                 SetTextStyle(DefaultFont,HorizDir,1);
                 OutTextXY(X1+(X2-X1) DIV 2,
                           Y2+Ruimte,'Arc en Ellips')
              END;
            6:BEGIN
                 SetColor(Green);
                 SetTextStyle(TriplexFont,HorizDir,1);
                 SetUserCharSize(1, 2, 1, 3);
                 OutTextXY(X1+(X2-X1) DIV 2,
                 Y2+Ruimte,'Taart statistiek')
              END;
            7:BEGIN
                 SetColor(LightBlue);
                 SetTextStyle(ScriptFont,HorizDir,1);
                 OutTextXY(X1+(X2-X1) DIV 2,
                         Y2+Ruimte,'LineTo, FillPoly')
              END
        END;
        INC(Teller)
     END
  END;
  Ch:=Readkey
END;

VAR
   Driver, Instelling:Integer;
BEGIN
   Driver:=Detect;
   InitGraph(Driver,Instelling,'');
   SetFillStyle(SolidFill,Blue);
   Bar(0,0,GetMaxX,GetMaxY * 5 DIV 100);
   SetTextJustify(CenterText,TopText);
   SetColor(Yellow);
   SetTextStyle(SimplexFont,HorizDir,1);
   OutTextXY(GetMaxX DIV 2,0,
      'Demonstratie Borland Graphics InterFace');
   SetTextJustify(CenterText,CenterText);
   ZetRijen(4,2);
   CloseGraph
END.

